/*:
 * @target MZ
 * @plugindesc HS_FastMode × GlobalSlowZoom 互換：高速ON時はズームdurationも短縮（保護中は無効）
 * @author HS
 */
(() => {
  "use strict";
  const HSP = PluginManager.parameters("HS_FastMode") || {};
  const INT_DIV = Math.max(1, Number(HSP["InterpreterWaitDivisor"] || 2));
  function fastOn() {
    const blocked = window.HS_FM ? window.HS_FM.isBlocked() : false;
    return !!ConfigManager.fastMode && !blocked && INT_DIV > 1;
  }
  function scaleDur(d) { return fastOn() ? Math.max(1, Math.floor(Number(d||0) / INT_DIV)) : Number(d||0); }
  function wrap(plugin, cmd) {
    const key = plugin + ":" + cmd;
    const table = PluginManager._commands || (PluginManager._commands = {});
    const orig = table[key];
    if (!orig) return;
    table[key] = function(args){ const a = Object.assign({}, args); if (a.duration != null) a.duration = String(scaleDur(a.duration)); return orig.call(this, a); };
  }
  wrap("GlobalSlowZoom","zoom"); wrap("GlobalSlowZoom","reset");
  const _register = PluginManager.registerCommand;
  PluginManager.registerCommand = function(p,c,f){ _register.call(this,p,c,f); if (p==="GlobalSlowZoom"&&(c==="zoom"||c==="reset")) wrap(p,c); };
})();
